﻿
CREATE PROCEDURE [App].[NVCC_usp_GetAppts]
	-- Add the parameters for the stored procedure here
	@pid bigint -- this is the patientsid

-- NOTICE:
-- Do not edit the stored procedure live on the server. Code to generate
-- the procedures is stored in the project repository. Any changes made
-- that are not recorded in the repository will be overwritten.

AS
--=================================================================================
--Requestor				: Non Va Coordinated Care Project
--Author                : Jerry Kohler (Original script by Dr. Charles Demosthenes)
--Object/SP Name		: NVCC_usp_GetAppts
--SERVER				: 
--Data Base				: CC_REFDOC
--Schema				: nva
--Report				: N/A
--Folder				: N/A
--Report Loc            : N/A
--Job                   : None
--Job Loc               : None
--Note                  : 
--Date Created          : 01-12-2016
--
--Last Changed          : 03-15-2017  
--Last Changed By		: Brian Diggs - Northwest Innovation Center (NWIC)
--Reason For Change		: Change AppointmentMadeDateTime to AppointmendMadeDate
--                        due to schema changes.
--
--Last Changed          : 02-18-2016  
--Last Changed By		: Jerry Kohler - Northwest Innovation Center (NWIC)
--Reason For Change		: Request to also provide the name of the station.
--
--Last Changed          : 01-12-2016  
--Last Changed By		: Jerry Kohler - Northwest Innovation Center (NWIC)
--Reason For Change		: Removed station parameter in order to expand the search
--                        for a patient's appointments from a single station to any
--                        station a patient is associated with.
--
--Purpose               : Retrieve a patient's appointments for inclusion into NVCC
--                        documentation
--=================================================================================
--Uses: App.udf_StationName
--Uses: CDWWork.Appt.Appointment
--Uses: CDWWork.Dim.Location
--Uses: App.udf_AllPatientsSIDs
BEGIN
   -- SET NOCOUNT ON added to prevent extra result sets from
   -- interfering with SELECT statements.
   SET NOCOUNT ON;

   SELECT --TOP (100)
      ap.Sta3n
     ,App.udf_StationName (ap.Sta3n) AS StationName
     ,loc.LocationName
     ,convert(varchar, AppointmentDateTime, 101) + ' ' + convert(varchar, AppointmentDateTime, 8) AS AppointmentDateTime
     ,ap.AppointmentSID
     ,ap.PatientSID
     ,ap.AppointmentTypeSID
     ,desireddate =
      CASE
         When DesiredAppointmentDate is null
         Then convert(varchar(12), cast(dateadd(day, 1, AppointmentDateTime) as date), 101)
         Else convert(varchar(12), cast(AppointmentDateTime as date), 101)
      END
     ,ap.CancelNoShowCode
     ,ap.LocationSID, ap.PurposeOfVisit
     ,ap.SchedulingRequestType
     ,ap.CancelDateTime
     ,ap.AppointmentCancelledFlag

   FROM CDWWork.Appt.Appointment AS ap
   JOIN CDWWork.Dim.Location AS loc ON ap.LocationSID = loc.LocationSID
   WHERE ap.AppointmentDateTime >= getdate() and ap.AppointmentDateTime < convert(DATE, dateadd(mm, 6, getdate()))
     AND ap.PatientSID  in (select PtSID from [App].[udf_AllPatientsSIDs](@pid));

END;

